﻿package com {
	import com.addthis.menu.services.Services;
	import com.addthis.menu.ui.controls.MenuBar;
	import com.addthis.menu.ui.util.Constants;
	import com.addthis.menu.util.Utils;
	import com.addthis.share.ShareAPI;
	
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	import flash.external.ExternalInterface;
	
	//import asual.swfaddress.SWFAddress;
	//import asual.swfaddress.SWFAddressEvent;
	
	import gs.*;
	import gs.easing.*;
 
    public class ShareAPICustom extends MovieClip {

        //Menu drawing constants
        private var displayStyle:int = 1;
        private var rowCount:int;
        private var columnCount:int;
        private var menuWidth:int;
        private var menuHeight:int;
        private var servicesInRow:int;
        private var serviceButtonWidth:int;      
          
        //Share class instance for sharing
        private var addthisShare:ShareAPI=new ShareAPI();
        
        //Url to be shared
        public var shareUrl:String;
		//public var pagePath:String = ExternalInterface.call('window.location.href.toString');
        
        //Content to be shared- expecting embed
        public var shareParams:Object;
		
        
		private var _root:MovieClip;
        /**
        * Constructor
        **/ 
		public function ShareAPICustom(rt:MovieClip) {
			_root = rt;
			trace("ok");
			var rows_XML:int = int(_root.program.websiteXML.widgets.@column);
			//var displ_XML:int = int(_root.program.websiteXML.widgets.@displayStyle);
			var align_XML:String = String(_root.program.websiteXML.widgets.@alignDisplay);
			
			drawMenu(rows_XML, 1 , align_XML);
		}
		
		/**
		* Drawing the menu according to the display style
		**/  
		private function drawMenu(rows:int = 1, display:int = 1, alignDispl:String = "left" ):void{
			//Variables
			var servicesList:Array = new Array;
			var widgetLength:Number = _root.program.websiteXML.widgets.widget.length();
			trace("widgetLength " + widgetLength);
			
			for (var CountWidgets:int = 0; CountWidgets < widgetLength; CountWidgets++) {
				
				var WidgetDisplayName:String = _root.program.websiteXML.widgets.widget[CountWidgets].displayName.text();
				var WidgetId:String = _root.program.websiteXML.widgets.widget[CountWidgets].id.text();
				
				var tempArrObj:Object = {displayName:String, id:String};
				tempArrObj.displayName = WidgetDisplayName;
				tempArrObj.id = WidgetId;
				
				servicesList.push( tempArrObj );
			}
			
			var i:int =0;
			var servicesCount:int;
			var yPosMult:int; 
			var j:int =0;
			var k:Number;
			
			
			//Updating rows and display styles
			rowCount = rows;
			displayStyle = display;
			
			//Populating menu drawing constants 
			serviceButtonWidth = getServiceButtonWidth(displayStyle); 
			servicesCount = Utils.getObjectCount(servicesList);
            columnCount = Utils.getUpperRoundedValue(servicesCount,rowCount);
            
            //Drawing according to display style		
			for(var item:int = 0; item < servicesList.length;item++)
			{
			   var serviceButton:MenuBar = new MenuBar(servicesList[item]);
	           switch(displayStyle){
		          case 1:
		             serviceButton.loadImageBig(servicesList[item].id,displayStyle);
		             break;
		          case 2:
		             serviceButton.setLabelBig(servicesList[item].displayName);
		             break;
		          case 3:
		             serviceButton.loadImageBig(servicesList[item].id,displayStyle);   
		             serviceButton.setLabelBig(servicesList[item].displayName,"comp");
		             break;   
		          default:
		             serviceButton.loadImage(servicesList[item].id,displayStyle);
	           }
               
               //Row column handling
               k = i/rowCount;
               k.toString().indexOf(".") < 0 ? j = 0:null;
               yPosMult = i/rowCount;
               
               //Position handling 
			   if(alignDispl == "left"){
					serviceButton.x = j !=0 ? Constants.BIG_SERVICE_BUTTON_LEFT_SPACING + (j * serviceButtonWidth) + (Constants.BIG_BUTTON_SPACING * j):Constants.BIG_SERVICE_BUTTON_LEFT_SPACING + (j * serviceButtonWidth);
					serviceButton.y = Constants.BIG_SERVICE_BUTTON_TOP_SPACING + yPosMult * Constants.BIG_MENU_ROW_HEIGHT;
			   }
               if(alignDispl == "right"){
					serviceButton.x = j !=0 ? -(Constants.BIG_SERVICE_BUTTON_LEFT_SPACING+serviceButtonWidth) - (j * serviceButtonWidth) - (Constants.BIG_BUTTON_SPACING * j):Constants.BIG_SERVICE_BUTTON_LEFT_SPACING - (j * serviceButtonWidth) - serviceButtonWidth;
					serviceButton.y = Constants.BIG_SERVICE_BUTTON_TOP_SPACING + yPosMult * Constants.BIG_MENU_ROW_HEIGHT;
				}
			   
               //Listners 
               serviceButton.addEventListener(MouseEvent.CLICK,clickedEvent);
               serviceButton.addEventListener(MouseEvent.MOUSE_OVER,mouseOverEvent);
               serviceButton.addEventListener(MouseEvent.MOUSE_OUT,mouseOutEvent);
               
               //Adding to stage
               addChild(serviceButton);
               
               //Increment handlers for row column
               i++;
               j++;
        	}
 		}
		
		/**
		* Handling click event of service buttons
		**/  
		private function clickedEvent(e:Event):void {
			
			shareUrl = ExternalInterface.call('window.location.href.toString');
			/*
			var pattern:RegExp = /w{3}\.\w+\.\w+/i;//регулярное вырожение для нахождения адреса сайта
			var  swfurl:String  = _root.loaderInfo.loaderURL;//Абсолютный путь к .swf файлу
			shareUrl = pattern.exec(swfurl);
			*/
			
			//shareParams = {title:String};
			//shareParams.title = String( SWFAddress.getTitle() );
			
			/*
			shareParams = {  swfurl:String, width:Number, height:Number, title:String, screenshot:String, description:String};
			shareParams.swfurl = _root.loaderInfo.loaderURL;
			shareParams.width = stage.stageWidth;
			shareParams.height = stage.stageHeight;
			shareParams.title = String( SWFAddress.getTitle() );
			shareParams.screenshot = pagePath + "site_screen.jpg";
			shareParams.description ="This is description of the site... This is description of the site... This is description of the site...";
			*/
			
			
			e.currentTarget.id != "more" ? addthisShare.share(shareUrl,e.currentTarget.id,shareParams):addthisShare.share(shareUrl,'menu',shareParams);
		}
		
		/**
		* Handling mouse over event of service buttons
		**/  
		var labelHint:TextField;
		private function mouseOverEvent(e:Event):void{
			
			var myObj = e.currentTarget;
			TweenMax.to(myObj, 0.6, { colorMatrixFilter: { contrast:1.5, brightness:1.5 }} );
			
			var fmt:TextFormat = new TextFormat();
			fmt.font = "Myriad Pro";
			fmt.color = 0x222222;
			fmt.bold = false;
			fmt.size = 12;
			
			labelHint = new TextField();
            labelHint.autoSize = TextFieldAutoSize.LEFT;
            labelHint.background = false;
            labelHint.border = false;	
			labelHint.embedFonts = true;
			labelHint.y = -15;
			labelHint.alpha = 0;
			
			labelHint.defaultTextFormat = fmt;
			labelHint.text = myObj.displayName;
            e.currentTarget.addChild(labelHint);
			TweenMax.to(labelHint, 0.6, { alpha: 1} );
			
		}
		
		/**
		* Handling mouse out event of service buttons
		**/  
		private function mouseOutEvent(e:Event):void{
			var myObj = e.currentTarget;
			TweenMax.to(myObj, 0.6, { colorMatrixFilter: { contrast:1, brightness:1 }} );
			myObj.removeChild(labelHint);
		}
		
		/**
		* Gets the width of the service button to draw 
		* according to the user passed value or default value
		**/
		private function getServiceButtonWidth(style:int):int{
			switch(style){
				case 1:
					return Constants.BIG_SERVICE_BUTTON_ICON_WIDTH ;
					break;
				case 2:
				    return Constants.BIG_SERVICE_BUTTON_TEXT_WIDTH ;
				    break;
				case 3:
				    return Constants.BIG_SERVICE_BUTTON_ICON_AND_TEXT_WIDTH ;
				    break;
				default:
				    return Constants.BIG_SERVICE_BUTTON_ICON_WIDTH ;
				    break;    
			}
		}
		
		/**
		* Configuring the content to be shared
		**/  
		/*public function configure(url:String,params:Object =null):void{
			shareUrl = url;
			shareParams = params;
		}*/
		
	}
}